/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.persist.util;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.util.PersistenceOperations;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PersistenceOperationsTasklet
extends Tasklet
implements PersistenceOperations {
    private static final String TRACE_MASKT = "XPERRGTT";
    private static final String TRACE_MASKF = "XPERRGTF";
    private static final String TRACE_MASKD = "XPERRGTD";

    public void init(Object initData) {
    }

    public void logException(Throwable throwable) {
    }

    public void service(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "PersistenceOperationsTasklet.service()");
        response.noAction();
        if (request.isInitialRequest()) {
            Trace.trace(TRACE_MASKF, "Initial request seen and ignored, now ready for action.");
        } else {
            Integer function = request.getData("function") == null ? PersistenceOperations.FUNCTION_NONE : (Integer)request.getData("function");
            switch (function) {
                case -1: {
                    Trace.trace(TRACE_MASKF, "FUNCTION = 'none', no action being taken.");
                    break;
                }
                case 0: 
                case 1: {
                    Trace.trace(TRACE_MASKF, "FUNCTION = 'save upgrade data'");
                    String targetFile = null;
                    if (function == 0) {
                        Trace.trace(TRACE_MASKF, "Specific file name passed by client.");
                        targetFile = (String)request.getData("function.sud.target");
                        if (targetFile == null) {
                            Trace.trace(TRACE_MASKF, "Warning, no target filename (SAVE_UPGRADE_DATA_TARGET_FILENAME_KEY) specified, action will be ignored.");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "Token passed by client is a BFC entry with optional suffix info.");
                        try {
                            String bfcToken = (String)request.getData("function.sud.target.bfc");
                            if (bfcToken != null) {
                                targetFile = BaseFileControl.getFilePath(bfcToken) + File.separator + "persistence.recovery";
                                String optionalSuffix = (String)request.getData("function.sud.target.suffix");
                                if (optionalSuffix != null) {
                                    targetFile = targetFile.concat(optionalSuffix);
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "Warning, no bfc token (SAVE_UPGRADE_DATA_TARGET_BFCTOKEN_KEY) specified, action will be ignored.");
                            }
                        }
                        catch (HException e) {
                            Trace.trace(TRACE_MASKF, "HException using BFC to form recovery file path name.");
                            Trace.trace(TRACE_MASKF, e);
                            response.setData("function.exception", e);
                        }
                    }
                    if (targetFile != null) {
                        Trace.trace(TRACE_MASKF, "Using target file: '" + targetFile + "'");
                        try {
                            File target = new File(targetFile);
                            try {
                                if (target.exists()) {
                                    Trace.trace(TRACE_MASKF, "Attempting delete of target file.");
                                    target.delete();
                                }
                            }
                            catch (SecurityException e) {
                                Trace.trace(TRACE_MASKF, "Attempted delete failed due to security exception.");
                                Trace.trace(TRACE_MASKF, e);
                                response.setData("function.exception", e);
                                return;
                            }
                            Trace.trace(TRACE_MASKF, "Creating output stream, calling PersistenceManager to save data.");
                            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(target), 10240);
                            PersistenceManager.getPersistenceManager().saveUpgradeData(os);
                            ((OutputStream)os).close();
                            response.setData("function.sud.target", targetFile);
                            Trace.trace(TRACE_MASKF, "Complete, data saved.");
                            break;
                        }
                        catch (UpgradeDataException e) {
                            Trace.trace(TRACE_MASKF, "UpgradeDataException attempting to save upgrade data.");
                            Trace.trace(TRACE_MASKF, e);
                            response.setData("function.exception", e);
                            return;
                        }
                        catch (IOException e) {
                            Trace.trace(TRACE_MASKF, "IOException attempting to save upgrade data.");
                            Trace.trace(TRACE_MASKF, e);
                            response.setData("function.exception", e);
                            return;
                        }
                    }
                    Trace.trace(TRACE_MASKF, "Unable to form a recovery target file name, no action being taken.");
                    break;
                }
                default: {
                    Trace.trace(TRACE_MASKF, "FUNCTION = " + function + ", which is *unknown*, no action being taken.");
                }
            }
        }
        Trace.trace(TRACE_MASKF, "service() returns");
    }
}

